/*
phantom.c
数値ファントムを読み込む
0=背景, 1=脂肪, 2=乳腺, 3=容器, 4=がん, 5=皮膚
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

void phantom(const char fn[], int nx, int ny, int nz, int ***map)
{
	// open
	FILE *fp;
	if ((fp = fopen(fn, "r")) == NULL) {
		fprintf(stderr, ">>> file %s open error", fn);
		exit(1);
	}

	// 初期化
	for (int i = 0; i < nx; i++) {
	for (int j = 0; j < ny; j++) {
	for (int k = 0; k < nz; k++) {
		map[i][j][k] = 0;
	}
	}
	}

	// dummy (gcc)
	char *s;
	int n = 0;

	// header
	char strline[BUFSIZ];
	int reso; // 解像度=1[mm]
	int nxf;  // X方向データ数=99
	int nzf;  // Z方向データ数=50
	int nyf;  // Y方向データ数=96
	s = fgets(strline, sizeof(strline), fp);
	sscanf(strline, "%d", &reso);
	s = fgets(strline, sizeof(strline), fp);
	sscanf(strline, "%d", &nxf);
	s = fgets(strline, sizeof(strline), fp);
	sscanf(strline, "%d", &nzf);
	s = fgets(strline, sizeof(strline), fp);
	sscanf(strline, "%d", &nyf);
	//printf("%d %d %d %d\n", reso, nxf, nyf, nzf);  // 1 99 96 50
	assert((reso == 1) && (nxf == 99) && (nyf == 96) && (nzf == 50));
	assert((nxf + 1 == nx) && (nyf + 4 == ny) && (nzf == nz));

	// body
	for (int j = 0; j < nyf; j++) {
	for (int k = 0; k < nzf; k++) {
	for (int i = 0; i < nxf; i++) {
		int num;
		n = fscanf(fp, "%d", &num);
		map[i][j + 2][k] = num;
	}
	}
	}

	// close
	fclose(fp);

	// dummy (gcc)
	s = s;
	n = n;

	// j=98補正
	for (int i = 0; i < nx; i++) {
	for (int k = 0; k < nz; k++) {
		map[i][98][k] = map[i][2][k];
	}
	}
/*
	// debug, 統計
	int tsum[6] = {0, 0, 0, 0, 0, 0};
	for (int i = 0; i < nx; i++) {
	for (int j = 0; j < ny; j++) {
	for (int k = 0; k < nz; k++) {
		tsum[map[i][j][k]]++;
	}
	}
	}
	printf("%d %d %d %d %d %d %d\n", tsum[0], tsum[1], tsum[2], tsum[3], tsum[4], tsum[5], tsum[0] + tsum[1] + tsum[2] + tsum[3] + tsum[4] + tsum[5]);
	// case1: 250151 192970 24291 29113 3475 0 500000
	// case2: 250151 177097 39234 29113 4405 0 500000
	// case3: 250151 178534 41562 29113 640 0 500000
*/
}
