/*
update.c
*/

// Ez更新
void updateEz(int ABC, int Nx, int Ny, float **Ez, float **Hx, float **Hy, float *dXn, float *dYn, float **C1Ez, float **C2Ez)
{
	const int i0 = (ABC == 0) ? 1 : 0;
	const int i1 = (ABC == 0) ? Nx : Nx + 1;
	const int j0 = (ABC == 0) ? 1 : 0;
	const int j1 = (ABC == 0) ? Ny : Ny + 1;

	for (int i = i0; i < i1; i++) {
	for (int j = j0; j < j1; j++) {
		Ez[i + ABC][j + ABC]
			= C1Ez[i][j] * Ez[i + ABC][j + ABC]
			+ C2Ez[i][j] * (dXn[i] * (Hy[i     + ABC][j     + ABC]
			                        - Hy[i - 1 + ABC][j     + ABC])
			              - dYn[j] * (Hx[i     + ABC][j     + ABC]
			                        - Hx[i     + ABC][j - 1 + ABC]));
	}
	}
}


// Hx更新
void updateHx(int ABC, int Nx, int Ny, float **Ez, float **Hx, float *dYc)
{
	for (int i = 0; i < Nx + 1; i++) {
	for (int j = 0; j < Ny + 0; j++) {
		Hx[i + ABC][j + ABC] =
		Hx[i + ABC][j + ABC] -
			dYc[j] * (Ez[i     + ABC][j + 1 + ABC]
			        - Ez[i     + ABC][j     + ABC]);
	}
	}
}


// Hy更新
void updateHy(int ABC, int Nx, int Ny, float **Ez, float **Hy, float *dXc)
{
	for (int i = 0; i < Nx + 0; i++) {
	for (int j = 0; j < Ny + 1; j++) {
		Hy[i + ABC][j + ABC] =
		Hy[i + ABC][j + ABC] +
			dXc[i] * (Ez[i + 1 + ABC][j     + ABC]
			        - Ez[i     + ABC][j     + ABC]);
	}
	}
}
