/*
txrx.c
送受信点座標
*/

//#include <stdio.h>
#include <assert.h>

void txrx(int Nx, int Ny, int Nz, int Nout, int Lant, const int Pant[][3],
	int NTx, int *iTx, int *jTx, int *kTx, int *mTx,
	int NRx, int *iRx, int *jRx, int *kRx, int *mRx)
{
	assert(NTx == NRx);

	// 送信点
	int ntx = 0;
	// -X面
	for (int j = 0; j < Pant[1][2]; j++) {
	for (int k = 0; k < Pant[2][2]; k++) {
		iTx[ntx] = Nout - Lant;  // -X面
		jTx[ntx] = Nout + Pant[1][0] + ((Pant[1][2] - 1 - j) * Pant[1][1]);  // +Y -> -Y
		const int ka = k;  // Z同方向(caseA)
		//const int ka = (j % 2 == 0) ? k : (Pant[2][2] - 1 - k);  // Z交互(caseB)
		kTx[ntx] = Nout + Pant[2][0] + (ka * Pant[2][1]);
		mTx[ntx] = 2;  // Z方向
		ntx++;
	}
	}
	// -Y面
	for (int i = 0; i < Pant[0][2]; i++) {
	for (int k = 0; k < Pant[2][2]; k++) {
		iTx[ntx] = Nout + Pant[0][0] + (i * Pant[0][1]);  // -X -> +X
		jTx[ntx] = Nout - Lant;  // -Y面
		const int ka = k;  // Z同方向(caseA)
		//const int ka = (i % 2 == 0) ? k : (Pant[2][2] - 1 - k);  // Z交互(caseB)
		kTx[ntx] = Nout + Pant[2][0] + (ka * Pant[2][1]);
		mTx[ntx] = 2;  // Z方向
		ntx++;
	}
	}
	assert(ntx == NTx);

	// 受信点（XY対称）
	for (int n = 0; n < NRx; n++) {
		iRx[n] = Nx - iTx[n];
		jRx[n] = Ny - jTx[n];
		kRx[n] = kTx[n];
		mRx[n] = mTx[n];
	}

	// check
	for (int n = 0; n < NTx; n++) {
		//printf("Tx: %d %d %d %d %d\n", n, iTx[n], jTx[n], kTx[n], mTx[n]);
		assert((iTx[n] > 0) && (iTx[n] < Nx) && (jTx[n] > 0) && (jTx[n] < Ny) && (kTx[n] > 0) && (kTx[n] < Nz));
		assert((mTx[n] >= 0) && (mTx[n] <= 2));
	}
	for (int n = 0; n < NRx; n++) {
		//printf("Rx: %d %d %d %d %d\n", n, iRx[n], jRx[n], kRx[n], mRx[n]);
		assert((iRx[n] > 0) && (iRx[n] < Nx) && (jRx[n] > 0) && (jRx[n] < Ny) && (kRx[n] > 0) && (kRx[n] < Nz));
		assert((mRx[n] >= 0) && (mRx[n] <= 2));
	}
}
