/*
update.c
*/

#include <stdio.h>

// Ex更新
void updateEx(int ABC, int Nx, int Ny, int Nz,
	float ***Ex, float ***Hy, float ***Hz, float *dYn, float *dZn, float ***C1Ex, float ***C2Ex)
{
	const int i0 = 0;
	const int i1 = Nx;
	const int j0 = (ABC == 0) ? 1 : 0;
	const int j1 = (ABC == 0) ? Ny : Ny + 1;
	const int k0 = (ABC == 0) ? 1 : 0;
	const int k1 = (ABC == 0) ? Nz : Nz + 1;

	for (int i = i0; i < i1; i++) {
	for (int j = j0; j < j1; j++) {
	for (int k = k0; k < k1; k++) {
		Ex[i + ABC][j + ABC][k + ABC]
			= C1Ex[i][j][k] * Ex[i + ABC][j + ABC][k + ABC]
			+ C2Ex[i][j][k] * (dYn[j] * (Hz[i     + ABC][j     + ABC][k     + ABC]
			                           - Hz[i     + ABC][j - 1 + ABC][k     + ABC])
			                 - dZn[k] * (Hy[i     + ABC][j     + ABC][k     + ABC]
			                           - Hy[i     + ABC][j     + ABC][k - 1 + ABC]));
	}
	}
	}
}


// Ey更新
void updateEy(int ABC, int Nx, int Ny, int Nz,
	float ***Ey, float ***Hz, float ***Hx, float *dZn, float *dXn, float ***C1Ey, float ***C2Ey)
{
	const int j0 = 0;
	const int j1 = Ny;
	const int k0 = (ABC == 0) ? 1 : 0;
	const int k1 = (ABC == 0) ? Nz : Nz + 1;
	const int i0 = (ABC == 0) ? 1 : 0;
	const int i1 = (ABC == 0) ? Nx : Nx + 1;

	for (int i = i0; i < i1; i++) {
	for (int j = j0; j < j1; j++) {
	for (int k = k0; k < k1; k++) {
		Ey[i + ABC][j + ABC][k + ABC]
			= C1Ey[i][j][k] * Ey[i + ABC][j + ABC][k + ABC]
			+ C2Ey[i][j][k] * (dZn[k] * (Hx[i     + ABC][j     + ABC][k     + ABC]
			                           - Hx[i     + ABC][j     + ABC][k - 1 + ABC])
			                 - dXn[i] * (Hz[i     + ABC][j     + ABC][k     + ABC]
			                           - Hz[i - 1 + ABC][j     + ABC][k     + ABC]));
	}
	}
	}
}


// Ez更新
void updateEz(int ABC, int Nx, int Ny, int Nz,
	float ***Ez, float ***Hx, float ***Hy, float *dXn, float *dYn, float ***C1Ez, float ***C2Ez)
{
	const int k0 = 0;
	const int k1 = Nz;
	const int i0 = (ABC == 0) ? 1 : 0;
	const int i1 = (ABC == 0) ? Nx : Nx + 1;
	const int j0 = (ABC == 0) ? 1 : 0;
	const int j1 = (ABC == 0) ? Ny : Ny + 1;

	for (int i = i0; i < i1; i++) {
	for (int j = j0; j < j1; j++) {
	for (int k = k0; k < k1; k++) {
		Ez[i + ABC][j + ABC][k + ABC]
			= C1Ez[i][j][k] * Ez[i + ABC][j + ABC][k + ABC]
			+ C2Ez[i][j][k] * (dXn[i] * (Hy[i     + ABC][j     + ABC][k     + ABC]
			                           - Hy[i - 1 + ABC][j     + ABC][k     + ABC])
			                 - dYn[j] * (Hx[i     + ABC][j     + ABC][k     + ABC]
			                           - Hx[i     + ABC][j - 1 + ABC][k     + ABC]));
	}
	}
	}
}


// Hx更新
void updateHx(int ABC, int Nx, int Ny, int Nz,
	float ***Hx, float ***Ey, float ***Ez, float *dYc, float *dZc)
{
	for (int i = 0; i < Nx + 1; i++) {
	for (int j = 0; j < Ny + 0; j++) {
	for (int k = 0; k < Nz + 0; k++) {
		Hx[i + ABC][j + ABC][k + ABC] =
		Hx[i + ABC][j + ABC][k + ABC]
			- dYc[j] * (Ez[i     + ABC][j + 1 + ABC][k     + ABC]
			          - Ez[i     + ABC][j     + ABC][k     + ABC])
			+ dZc[k] * (Ey[i     + ABC][j     + ABC][k + 1 + ABC]
			          - Ey[i     + ABC][j     + ABC][k     + ABC]);
	}
	}
	}
}


// Hy更新
void updateHy(int ABC, int Nx, int Ny, int Nz,
	float ***Hy, float ***Ez, float ***Ex, float *dZc, float *dXc)
{
	for (int i = 0; i < Nx + 0; i++) {
	for (int j = 0; j < Ny + 1; j++) {
	for (int k = 0; k < Nz + 0; k++) {
		Hy[i + ABC][j + ABC][k + ABC] =
		Hy[i + ABC][j + ABC][k + ABC]
			- dZc[k] * (Ex[i     + ABC][j     + ABC][k + 1 + ABC]
			          - Ex[i     + ABC][j     + ABC][k     + ABC])
			+ dXc[i] * (Ez[i + 1 + ABC][j     + ABC][k     + ABC]
			          - Ez[i     + ABC][j     + ABC][k     + ABC]);
	}
	}
	}
}


// Hz更新
void updateHz(int ABC, int Nx, int Ny, int Nz,
	float ***Hz, float ***Ex, float ***Ey, float *dXc, float *dYc)
{
	for (int i = 0; i < Nx + 0; i++) {
	for (int j = 0; j < Ny + 0; j++) {
	for (int k = 0; k < Nz + 1; k++) {
		Hz[i + ABC][j + ABC][k + ABC] =
		Hz[i + ABC][j + ABC][k + ABC]
			- dXc[i] * (Ey[i + 1 + ABC][j     + ABC][k     + ABC]
			          - Ey[i     + ABC][j     + ABC][k     + ABC])
			+ dYc[j] * (Ex[i     + ABC][j + 1 + ABC][k     + ABC]
			          - Ex[i     + ABC][j     + ABC][k     + ABC]);
	}
	}
	}
}
